/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.export;

import filenet.vw.toolkit.admin.VWConfigBaseNode;
import filenet.vw.toolkit.admin.VWConfigFolderNode;
import filenet.vw.toolkit.admin.export.VWExportImportTreePanel;
import filenet.vw.toolkit.admin.images.VWImageLoader;
import filenet.vw.toolkit.admin.resources.VWResource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.SystemColor;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.LineBorder;
import javax.swing.tree.TreeCellRenderer;

public class VWExportTreeCellRender
extends JPanel
implements TreeCellRenderer {
    protected JCheckBox m_checkBox = null;
    protected JLabel m_label = null;
    private Dimension m_checkBoxDim;
    private static final ImageIcon ICON_SELECTED = VWImageLoader.createImageIcon("selected_16.gif");
    private static final ImageIcon ICON_UNSELECTED = VWImageLoader.createImageIcon("unselected_16.gif");
    private static final ImageIcon ICON_PARTIALSELECTED = VWImageLoader.createImageIcon("partialselected_16.gif");

    public VWExportTreeCellRender(VWExportImportTreePanel eventPanel) {
        this.setOpaque(true);
        this.setLayout(null);
        this.m_checkBox = new JCheckBox();
        this.add(this.m_checkBox);
        this.m_label = new JLabel();
        this.add(this.m_label);
        this.m_checkBoxDim = this.m_checkBox.getPreferredSize();
    }

    public Dimension getCheckBoxDim() {
        return this.m_checkBoxDim;
    }

    public Dimension getPreferredSize() {
        Dimension labelDim = this.m_label.getPreferredSize();
        Dimension checkBoxDim = this.m_checkBox.getPreferredSize();
        int nWidth = checkBoxDim.width + labelDim.width + 2;
        int nHeight = checkBoxDim.height < labelDim.height ? labelDim.height : checkBoxDim.height;
        return new Dimension(nWidth, nHeight);
    }

    public void doLayout() {
        Dimension labelDim = this.m_label.getPreferredSize();
        int nCheckY = 0;
        int nCheckX = 0;
        if (this.m_checkBoxDim.height > labelDim.height) {
            nCheckY = (labelDim.height - this.m_checkBoxDim.height) / 2;
        }
        this.m_checkBox.setLocation(nCheckX, nCheckY);
        this.m_checkBox.setBounds(nCheckX, nCheckY, this.m_checkBoxDim.width, this.m_checkBoxDim.height);
        this.m_label.setLocation(nCheckX += this.m_checkBoxDim.width, 0);
        this.m_label.setBounds(nCheckX, 0, labelDim.width, labelDim.height);
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean bSelected, boolean bExpanded, boolean bLeaf, int row, boolean bHasFocus) {
        VWConfigBaseNode bNode = (VWConfigBaseNode)value;
        this.setToolTipText(bNode.getDescription());
        int type = bNode.getType();
        switch (type) {
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                if (bExpanded) {
                    this.m_label.setIcon(((VWConfigFolderNode)value).getOpenIcon16());
                    break;
                }
                this.m_label.setIcon(((VWConfigFolderNode)value).getClosedIcon16());
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 17: 
            case 18: 
            case 19: {
                this.m_label.setIcon(bNode.getIcon16());
                break;
            }
        }
        this.m_label.setText(bNode.getName());
        switch (bNode.getExportOptSelection()) {
            case 0: {
                this.m_checkBox.setIcon(ICON_UNSELECTED);
                this.m_checkBox.setSelected(false);
                break;
            }
            case 2: {
                this.m_checkBox.setIcon(ICON_SELECTED);
                this.m_checkBox.setSelected(true);
                break;
            }
            case 1: {
                this.m_checkBox.setIcon(ICON_PARTIALSELECTED);
                this.m_checkBox.setSelected(true);
                this.m_label.setText(VWResource.PartialSelectedNodeName.toString(bNode.getName()));
            }
        }
        if (bSelected) {
            if (bHasFocus) {
                this.setForeground(SystemColor.textHighlightText);
                this.setBackground(SystemColor.textHighlight);
                this.m_checkBox.setBackground(SystemColor.textHighlight);
                this.m_label.setBackground(SystemColor.textHighlight);
                this.m_label.setForeground(SystemColor.textHighlightText);
            } else {
                this.setBackground(SystemColor.menu);
                this.setForeground(SystemColor.textText);
                this.m_checkBox.setBackground(SystemColor.menu);
                this.m_label.setBackground(SystemColor.menu);
                this.m_label.setForeground(SystemColor.textText);
            }
            this.setBorder(new LineBorder(SystemColor.windowBorder));
            this.m_checkBox.setBorder(new LineBorder(SystemColor.windowBorder));
            this.m_label.setBorder(new LineBorder(SystemColor.windowBorder));
        } else {
            this.setBackground(tree.getBackground());
            this.setForeground(tree.getForeground());
            this.m_checkBox.setBackground(tree.getBackground());
            this.m_label.setBackground(tree.getBackground());
            this.m_label.setForeground(tree.getForeground());
            this.setBorder(new LineBorder(tree.getBackground()));
            this.m_checkBox.setBorder(new LineBorder(tree.getBackground()));
            this.m_label.setBorder(new LineBorder(tree.getBackground()));
        }
        return this;
    }
}

